import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Define colors
ingredient1_color = 'red'
ingredient2_color = 'blue'
empty_clean_color = 'white'
text_color = 'black'

# Add dispensers
ax.add_patch(patches.Rectangle((1, 8), 2, 1, edgecolor='black', facecolor=ingredient1_color))
ax.text(2, 8.5, 'dispenser_1\n(ingredient1)', color=text_color, ha='center', va='center')

ax.add_patch(patches.Rectangle((7, 8), 2, 1, edgecolor='black', facecolor=ingredient2_color))
ax.text(8, 8.5, 'dispenser_2\n(ingredient2)', color=text_color, ha='center', va='center')

# Add shots
ax.add_patch(patches.Rectangle((1, 5), 1, 1, edgecolor='black', facecolor=empty_clean_color))
ax.text(1.5, 5.5, 'shot_1\nclean, empty', color=text_color, ha='center', va='center')

ax.add_patch(patches.Rectangle((4.5, 5), 1, 1, edgecolor='black', facecolor=empty_clean_color))
ax.text(5, 5.5, 'shot_2\nclean, empty', color=text_color, ha='center', va='center')

ax.add_patch(patches.Rectangle((8, 5), 1, 1, edgecolor='black', facecolor=empty_clean_color))
ax.text(8.5, 5.5, 'shot_3\nclean, empty', color=text_color, ha='center', va='center')

# Add shaker
ax.add_patch(patches.Circle((5, 2), 0.75, edgecolor='black', facecolor=empty_clean_color))
ax.text(5, 2, 'shaker_1\nclean, l0', color=text_color, ha='center', va='center')

# Add hands
ax.add_patch(patches.Rectangle((1, 1), 1, 0.5, edgecolor='black', facecolor=empty_clean_color))
ax.text(1.5, 1.25, 'left_hand\nempty', color=text_color, ha='center', va='center')

ax.add_patch(patches.Rectangle((8, 1), 1, 0.5, edgecolor='black', facecolor=empty_clean_color))
ax.text(8.5, 1.25, 'right_hand\nempty', color=text_color, ha='center', va='center')

# Add legend
legend_elements = [
    patches.Patch(facecolor=ingredient1_color, edgecolor='black', label='ingredient1'),
    patches.Patch(facecolor=ingredient2_color, edgecolor='black', label='ingredient2'),
    patches.Patch(facecolor=empty_clean_color, edgecolor='black', label='clean, empty')
]
ax.legend(handles=legend_elements, loc='upper right')

# Set limits and hide axes
ax.set_xlim(0, 10)
ax.set_ylim(0, 10)
ax.axis('off')

# Save the figure
plt.savefig('barman/one_shot/ini_diagram_code/attempts/attempt_21.png')
plt.show()